/*******************************************************
Filename		:  project_rel_tables.sql
Release 		:  c2.0
SIR			:  1515
Description		:  create and populate station_project_table table.
Author			:  Joseph Wilson
Date			:  1/9/2003
			   7-01-2003 -- changed table names from CHEM to REGULAR
Comments		:  06/13/03 updated v2.0
			   07/16/2003 v2.0B - Added Habitat and Biological project tables. WN
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
**********************************************************/

SPOOL project_rel_tables.log

drop table station_project;

create table station_project 
tablespace storetdata
storage (initial 5M next 5M)
nologging
as select pr.pk_isn fk_project, st.pk_isn fk_station
from di_project pr, storet1.tsmpsa psa, fa_station st
where pr.tsmproj_is_number = psa.tsmproj_is_number
and pr.tsmproj_org_id = psa.tsmproj_org_id
and tsmstatn_is_number = station_is_number
and tsmstatn_org_id = organization_id
and st.location_point_type = '*POINT OF RECORD';

commit;

drop table REGULAR_RESULT_PROJECT;

create table REGULAR_RESULT_PROJECT (
fk_project number(12),
fk_result number (12))
tablespace storetdata
storage(initial 25M next 25M minextents 2 maxextents 200)
nologging
pctfree 1;

-- ADDED HABITAT_RESULT_PROJECT
drop table HABITAT_RESULT_PROJECT;

create table HABITAT_RESULT_PROJECT (
fk_project number(12),
fk_result number (12))
tablespace storetdata
storage(initial 25M next 25M minextents 2 maxextents 200)
nologging
pctfree 1;
--
-- ADDED BIOLOGICAL_RESULT_PROJECT
drop table BIOLOGICAL_RESULT_PROJECT;

create table BIOLOGICAL_RESULT_PROJECT (
fk_project number(12),
fk_result number (12))
tablespace storetdata
storage(initial 25M next 25M minextents 2 maxextents 200)
nologging
pctfree 1;
--

set serveroutput on
DECLARE

cursor orgs is
	select organization_id
	from di_org;

BEGIN

FOR v_org in orgs loop

Insert into REGULAR_RESULT_PROJECT 
select pr.pk_isn fk_project, re.pk_isn fk_result
from di_project pr, storet1.tsrfapra fap, FA_REGULAR_RESULT re
where pr.tsmproj_is_number = fap.tsmproj_is_number
and pr.tsmproj_org_id = fap.tsmproj_org_id
and fap.tsrfdact_is_number = re.activity_is_number
and fap.tsrfdact_org_id = re.organization_id
and organization_id = v_org.organization_id;

commit;
--
-- LOAD HABITAT RESULT_PROJECT
Insert into HABITAT_RESULT_PROJECT 
select pr.pk_isn fk_project, re.pk_isn fk_result
from di_project pr, storet1.tsrfapra fap, FA_HABITAT_RESULT re
where pr.tsmproj_is_number = fap.tsmproj_is_number 
and pr.tsmproj_org_id = fap.tsmproj_org_id
and fap.tsrfdact_is_number = re.activity_is_number
and fap.tsrfdact_org_id = re.organization_id
and organization_id = v_org.organization_id;

commit;
--
-- LOAD BIOLOGICAL RESULT_PROJECT
Insert into BIOLOGICAL_RESULT_PROJECT 
select pr.pk_isn fk_project, re.pk_isn fk_result
from di_project pr, storet1.tsrfapra fap, FA_BIOLOGICAL_RESULT re
where pr.tsmproj_is_number = fap.tsmproj_is_number 
and pr.tsmproj_org_id = fap.tsmproj_org_id
and fap.tsrfdact_is_number = re.activity_is_number
and fap.tsrfdact_org_id = re.organization_id
and organization_id = v_org.organization_id;

commit;

END LOOP;
END;
/

CREATE INDEX ISP_FK_FA_STATN ON STATION_PROJECT(FK_STATION)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX ISP_FK_PROJECT ON STATION_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_RESULT ON REGULAR_RESULT_PROJECT(FK_RESULT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_PROJECT ON REGULAR_RESULT_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IRP_FK_PROJECT_RESULT ON REGULAR_RESULT_PROJECT(FK_PROJECT,fk_result)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;
--
CREATE INDEX IHP_FK_RESULT ON HABITAT_RESULT_PROJECT(FK_RESULT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IHP_FK_PROJECT ON HABITAT_RESULT_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IHP_FK_PROJECT_RESULT ON HABITAT_RESULT_PROJECT(FK_PROJECT,fk_result)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;
--
--
CREATE INDEX IBP_FK_RESULT ON BIOLOGICAL_RESULT_PROJECT(FK_RESULT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IBP_FK_PROJECT ON BIOLOGICAL_RESULT_PROJECT(FK_PROJECT)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;

CREATE INDEX IBP_FK_PROJECT_RESULT ON BIOLOGICAL_RESULT_PROJECT(FK_PROJECT,fk_result)
TABLESPACE storetindx
storage ( initial 10M next 10M) nologging;
--
--add constraints
alter table REGULAR_RESULT_PROJECT 
add constraint re_proj_fk_result foreign key (fk_result) references FA_REGULAR_RESULT(pk_isn);

alter table REGULAR_RESULT_PROJECT 
add constraint re_proj_fk_project foreign key (fk_project) references di_project(pk_isn);
--
alter table HABITAT_RESULT_PROJECT 
add constraint hb_proj_fk_result foreign key (fk_result) references FA_HABITAT_RESULT(pk_isn);

alter table HABITAT_RESULT_PROJECT 
add constraint hb_proj_fk_project foreign key (fk_project) references di_project(pk_isn);
--
alter table BIOLOGICAL_RESULT_PROJECT 
add constraint bi_proj_fk_result foreign key (fk_result) references FA_BIOLOGICAL_RESULT(pk_isn);

alter table BIOLOGICAL_RESULT_PROJECT 
add constraint bi_proj_fk_project foreign key (fk_project) references di_project(pk_isn);

--drop columns from di_project
alter table di_project drop column tsmproj_is_number;
alter table di_project drop column tsmproj_org_id;

SPOOL OFF